-- Tabele z pliku PrzepisyStruktura.sql muszą zostać utworzone najpierw.

USE PrzepisyPrzyklad;
GO

CREATE VIEW R04_lista_wszystkich_skladnikow
AS
SELECT     NazwaSkladnika
FROM         Skladniki;
GO

CREATE VIEW R04_glowne_informacje_o_przepisach
AS
SELECT     TOP 100 PERCENT Przepisy.*
FROM         Przepisy
ORDER BY NazwaPrzepisu;
GO

CREATE VIEW R04_identyfikatory_kategorii_przepisow
AS
SELECT DISTINCT IDKategoriiPrzepisu
FROM         Przepisy;
GO

CREATE VIEW R04_kategorie_i_nazwy_przepisow
AS
SELECT     TOP 100 PERCENT IDKategoriiPrzepisu, NazwaPrzepisu
FROM         Przepisy
ORDER BY IDKategoriiPrzepisu, NazwaPrzepisu;
GO

CREATE VIEW R06_piec_pierwszych_przepisow
AS
SELECT     IDPrzepisu, NazwaPrzepisu, SposobPrzyrzadzania, Uwagi
FROM         Przepisy
WHERE     (IDPrzepisu BETWEEN 1 AND 5);
GO

CREATE VIEW R06_dania_glowne_z_uwagami
AS
SELECT     NazwaPrzepisu, SposobPrzyrzadzania, Uwagi
FROM         Przepisy
WHERE     (IDKategoriiPrzepisu = 1) AND (Uwagi IS NOT NULL);
GO

CREATE VIEW R06_miesa_z_wyjatkiem_kurczaka
AS
SELECT     NazwaSkladnika
FROM         Skladniki
WHERE     (NazwaSkladnika NOT LIKE '%urczak%') AND (IDKategoriiSkladnika = 2);
GO

CREATE VIEW R06_przepisy_bez_uwag
AS
SELECT     NazwaPrzepisu
FROM         Przepisy
WHERE     (Uwagi IS NULL);
GO

CREATE VIEW R08_przepisy_z_wolowina_i_czosnkiem
AS
SELECT     BeefPrzepisy.NazwaPrzepisu
FROM         (SELECT     Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
                       FROM          (Przepisy INNER JOIN
                                              Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu) INNER JOIN
                                              Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                       WHERE      Skladniki.NazwaSkladnika = 'Wołowina') BeefPrzepisy INNER JOIN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Czosnek') GarlicPrzepisy ON BeefPrzepisy.IDPrzepisu = GarlicPrzepisy.IDPrzepisu;
GO

CREATE VIEW R08_przepisy_z_wolowina_lub_czosnkiem
AS
SELECT DISTINCT Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu
WHERE     (Skladniki_przepisow.IDSkladnika IN (1, 9));
GO

CREATE VIEW R08_skladniki_ta_sama_miara
AS
SELECT     Pierwszy_skladnik.PierwszaNazwaSkladnika, Pierwszy_skladnik.OpisMiary, Drugi_skladnik.DrugaNazwaSkladnika
FROM         (SELECT     Skladniki.NazwaSkladnika AS PierwszaNazwaSkladnika, Miary.OpisMiary
                       FROM          Skladniki INNER JOIN
                                              Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci) Pierwszy_skladnik INNER JOIN
                          (SELECT     Skladniki.NazwaSkladnika AS DrugaNazwaSkladnika, Miary.OpisMiary
                            FROM          Skladniki INNER JOIN
                                                   Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci) Drugi_skladnik ON 
                      Pierwszy_skladnik.PierwszaNazwaSkladnika <> Drugi_skladnik.DrugaNazwaSkladnika AND 
                      Pierwszy_skladnik.OpisMiary = Drugi_skladnik.OpisMiary;
GO

CREATE VIEW R08_skladniki_dan_glownych
AS
SELECT     Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika, Miary.OpisMiary, Skladniki_przepisow.Ilosc
FROM         Kategorie_przepisow INNER JOIN
                      Przepisy ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                      Miary ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci
WHERE     (Kategorie_przepisow.OpisKategoriiPrzepisu = 'Dania główne');
GO

CREATE VIEW R08_przepisy_zawierajace_marchew
AS
SELECT     Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Marchew') Carrots ON Przepisy.IDPrzepisu = Carrots.IDPrzepisu;
GO

CREATE VIEW R08_przepisy_zawierajace_nabial
AS
SELECT DISTINCT Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                      Kategorie_skladnikow ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Nabiał');
GO

CREATE VIEW R08_salatki
AS
SELECT     Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Kategorie_przepisow ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
WHERE     (Kategorie_przepisow.OpisKategoriiPrzepisu = 'Sałatki');
GO

CREATE VIEW R09_wszystkie_skladniki_dowolne_przepisy
AS
SELECT     Skladniki.NazwaSkladnika, R.IDPrzepisu, R.NazwaPrzepisu
FROM         Skladniki LEFT OUTER JOIN
                          (SELECT DISTINCT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, Skladniki_przepisow.IDSkladnika
                            FROM          Przepisy INNER JOIN
                                                   Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu) R ON Skladniki.IDSkladnika = R.IDSkladnika;
GO

CREATE VIEW R09_wszystkie_kategorie_przepisow_wszystkie_przepisy
AS
SELECT     TOP (100) PERCENT Kategorie_przepisow.OpisKategoriiPrzepisu, Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika, Skladniki_przepisow.NumerKrokuPrzepisu, 
                 Skladniki_przepisow.Ilosc, Miary.OpisMiary
FROM       Przepisy LEFT OUTER JOIN Skladniki_przepisow 
              ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu 
           INNER JOIN Miary 
              ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci 
           FULL OUTER JOIN Skladniki 
              ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika 
           FULL OUTER JOIN Kategorie_przepisow 
              ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
ORDER BY Kategorie_przepisow.OpisKategoriiPrzepisu DESC, Przepisy.NazwaPrzepisu, Skladniki_przepisow.NumerKrokuPrzepisu;
GO

CREATE VIEW R09_wszystkie_kategorie_i_pasujace_przepisy
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu, Przepisy.NazwaPrzepisu
FROM         Kategorie_przepisow LEFT OUTER JOIN
                      Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu;
GO

CREATE VIEW R09_niewykorzystane_skladniki
AS
SELECT     Skladniki.NazwaSkladnika
FROM         Skladniki LEFT OUTER JOIN
                      Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE     (Skladniki_przepisow.IDPrzepisu IS NULL);
GO

CREATE VIEW R09_kategorie_bez_przepisow
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu
FROM         Kategorie_przepisow LEFT OUTER JOIN
                      Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu
WHERE     (Przepisy.IDPrzepisu IS NULL);
GO

CREATE VIEW R09_salatki_zupy_dania_glowne
AS
SELECT     RCFiltered.NazwaKategorii, R.NazwaPrzepisu
FROM         (SELECT     RC.IDKategoriiPrzepisu, RC.OpisKategoriiPrzepisu AS NazwaKategorii
                       FROM          Kategorie_przepisow AS RC
                       WHERE      RC.OpisKategoriiPrzepisu = 'Sałatki' OR
                                              RC.OpisKategoriiPrzepisu = 'Zupy' OR
                                              RC.OpisKategoriiPrzepisu = 'Dania główne') RCFiltered LEFT OUTER JOIN
                      Przepisy R ON RCFiltered.IDKategoriiPrzepisu = R.IDKategoriiPrzepisu;
GO

CREATE VIEW R10_kategorie_przepisy_skladniki
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu AS IndexName, 'Kategoria przepisów' AS Typ
FROM         Kategorie_przepisow
UNION
SELECT     Przepisy.NazwaPrzepisu, 'Przepis' AS Typ
FROM         Przepisy
UNION
SELECT     Skladniki.NazwaSkladnika, 'Składnik' AS Typ
FROM         Skladniki;
GO

CREATE VIEW R10_jednostki_miary_skladnikow_w_przepisach
AS
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary, 'Składnik' AS Typ
FROM         Miary INNER JOIN
                      Skladniki ON (Miary.IDMiaryIlosci = Skladniki.IDMiaryIlosci)
UNION
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary, 'Przepis' AS Typ
FROM         (Miary INNER JOIN
                      Skladniki_przepisow ON (Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci)) INNER JOIN
                      Skladniki ON (Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika);
GO

CREATE VIEW R11_liczba_przepisow_w_kategoriach
AS
SELECT     IDKategoriiPrzepisu, OpisKategoriiPrzepisu,
                          (SELECT     COUNT(*)
                            FROM          Przepisy
                            WHERE      Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu) AS LiczbaPrzepisow
FROM         Kategorie_przepisow;
GO

CREATE VIEW R11_skladniki_uzyte_w_niestandardowych_ilosciach
AS
SELECT     IDSkladnika, NazwaSkladnika, IDMiaryIlosci
FROM         Skladniki
WHERE     (IDMiaryIlosci <> ANY
                          (SELECT     Skladniki_przepisow.IDMiaryIlosci
                            FROM          Skladniki_przepisow
                            WHERE      Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika));
GO

CREATE VIEW R11_liczba_przepisow_z_roznymi_rodzajami_mies
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika,
                          (SELECT     COUNT(*)
                            FROM          Skladniki_przepisow
                            WHERE      Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) AS LiczbaPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Mięsa');
GO

CREATE VIEW R11_skladniki_przepisow_z_marchwia
AS
SELECT     Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE     (Przepisy.IDPrzepisu IN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Marchew'));
GO

CREATE VIEW R12_liczba_skladnikow_mierzonych_szklanka
AS
SELECT     COUNT(*) AS LiczbaSkladnikow
FROM         Skladniki INNER JOIN
                      Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci
WHERE     (Miary.OpisMiary = 'Szklanka');
GO

CREATE VIEW R12_liczba_przepisow_na_dania_glowne
AS
SELECT DISTINCT COUNT(*) AS LiczbaPrzepisow
FROM         Przepisy INNER JOIN
                      Kategorie_przepisow ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
WHERE     (Kategorie_przepisow.OpisKategoriiPrzepisu = 'Dania główne');
GO

CREATE VIEW R12_przepis_z_najwieksza_liczba_zabkow_czosnku
AS
SELECT DISTINCT Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
WHERE     (Skladniki.NazwaSkladnika = 'Czosnek') AND (Skladniki_przepisow.Ilosc =
                          (SELECT     MAX(Ilosc)
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
                            WHERE      NazwaSkladnika = 'Czosnek'));
GO

CREATE VIEW R12_przepisy_z_wolowina
AS
SELECT     COUNT(*) AS LiczbaPrzepisow
FROM         Przepisy
WHERE     (IDPrzepisu IN
                          (SELECT     IDPrzepisu
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
                            WHERE      NazwaSkladnika LIKE '%Wołowina%'));
GO

CREATE VIEW R12_calkowita_ilosc_soli_w_przepisach
AS
SELECT     SUM(Skladniki_przepisow.Ilosc) AS LiczbaLyzeczek
FROM         Skladniki_przepisow INNER JOIN
                      Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
WHERE     (Skladniki.NazwaSkladnika = 'Sól');
GO

CREATE VIEW R13_liczba_roznych_przepisow_dla_kat_skladnikow
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, COUNT(DISTINCT Skladniki_przepisow.IDPrzepisu) AS LiczbaIDPrzepisu
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika INNER JOIN
                      Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
GROUP BY Kategorie_skladnikow.OpisKategoriiSkladnika;
GO

CREATE VIEW R13_liczba_przepisow_z_miesem_grupowanie
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika, COUNT(*) AS LiczbaPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika INNER JOIN
                      Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Mięsa')
GROUP BY Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika;
GO

CREATE VIEW R13_liczba_przepisow_z_miesem_podzapytanie
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika,
                          (SELECT     COUNT(*)
                            FROM          Skladniki_przepisow
                            WHERE      Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) AS LiczbaPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Mięsa');
GO

CREATE VIEW R13_laczna_ilosc_skladnikow
AS
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary, SUM(Skladniki_przepisow.Ilosc) AS SumaIlosci
FROM         Skladniki INNER JOIN
                      Miary INNER JOIN
                      Skladniki_przepisow ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci ON 
                      Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
GROUP BY Skladniki.NazwaSkladnika, Miary.OpisMiary;
GO

CREATE VIEW R14_kategorie_przepisow_wymagajace_mnostwa_soli
AS
SELECT Kategorie_przepisow.OpisKategoriiPrzepisu, Skladniki.NazwaSkladnika, Sum(Skladniki_przepisow.Ilosc) AS SumaLyzeczekSoli
FROM (((Kategorie_przepisow INNER JOIN Przepisy 
ON Kategorie_przepisow.IDKategoriiPrzepisu=Przepisy.IDKategoriiPrzepisu) 
INNER JOIN Skladniki_przepisow 
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu) 
INNER JOIN Skladniki 
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika) 
INNER JOIN Miary 
ON Miary.IDMiaryIlosci=Skladniki_przepisow.IDMiaryIlosci
WHERE Skladniki.NazwaSkladnika='Sól' 
   And Miary.OpisMiary='Łyżeczka'
GROUP BY Kategorie_przepisow.OpisKategoriiPrzepisu, Skladniki.NazwaSkladnika
HAVING Sum(Skladniki_przepisow.Ilosc)>3;
GO

CREATE VIEW R14_kategorie_z_co_najmniej_dwoma_przepisami
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu, COUNT(Przepisy.IDPrzepisu) AS LiczbaIDPrzepisu
FROM         Kategorie_przepisow INNER JOIN
                      Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu
GROUP BY Kategorie_przepisow.OpisKategoriiPrzepisu
HAVING      (COUNT(Przepisy.IDPrzepisu) >= 2);
GO

CREATE VIEW R14_przepisy_z_wolowina_i_czosnkiem
AS
SELECT     NazwaPrzepisu
FROM         Przepisy
WHERE     (IDPrzepisu IN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Wołowina' OR
                                                   Skladniki.NazwaSkladnika = 'Czosnek'
                            GROUP BY Skladniki_przepisow.IDPrzepisu
                            HAVING      COUNT(Skladniki_przepisow.IDPrzepisu) = 2));
GO

CREATE VIEW R18_skladniki_bez_przepisow
AS 
SELECT Skladniki.NazwaSkladnika
FROM Skladniki
WHERE Skladniki.IDSkladnika NOT IN 
(SELECT Skladniki_przepisow.IDSkladnika FROM Skladniki_przepisow);
GO

CREATE VIEW R18_skladniki_nieuzyte_w_gulaszu_pollo_steku_NOTIN
AS 
SELECT Skladniki.IDSkladnika, Skladniki.NazwaSkladnika
FROM Skladniki
WHERE Skladniki.IDSkladnika NOT IN 
(SELECT Skladniki_przepisow.IDSkladnika 
FROM Skladniki_przepisow
INNER JOIN Przepisy 
ON Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu 
WHERE NazwaPrzepisu IN 
('Gulasz irlandzki', 'Pollo z kurczakiem', 'Stek wołowy'));
GO

CREATE VIEW R18_kategorie_przepisow_bez_przepisow_NOT_IN
AS 
SELECT Kategorie_przepisow.OpisKategoriiPrzepisu
FROM Kategorie_przepisow
WHERE Kategorie_przepisow.IDKategoriiPrzepisu NOT IN 
(SELECT Przepisy.IDKategoriiPrzepisu 
FROM Przepisy);
GO

CREATE VIEW R18_przepisy_co_najmniej_3_takie_same_skladniki
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, R2.IDPrzepisu AS R2ID, R2.NazwaPrzepisu AS Nazwa2P, Count(Skladniki_przepisow.IDPrzepisu) AS LiczbaIDPrzepisu
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki_przepisow AS RI2
ON Skladniki_przepisow.IDSkladnika=RI2.IDSkladnika)
INNER JOIN Przepisy AS R2
ON R2.IDPrzepisu=RI2.IDPrzepisu
WHERE RI2.IDPrzepisu>Przepisy.IDPrzepisu
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, R2.IDPrzepisu, R2.NazwaPrzepisu
HAVING Count(Skladniki_przepisow.IDPrzepisu)>=3;
GO

CREATE VIEW R18_przepisy_z_wolowina_i_czosnkiem
AS 
SELECT Przepisy.NazwaPrzepisu, Przepisy.SposobPrzyrzadzania
FROM Przepisy
WHERE EXISTS 
(SELECT Skladniki_przepisow.*
FROM Skladniki
INNER JOIN Skladniki_przepisow
ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE Skladniki.NazwaSkladnika='Wołowina'
AND Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu)
AND EXISTS 
(SELECT Skladniki_przepisow.*
FROM Skladniki
INNER JOIN Skladniki_przepisow
ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE Skladniki.NazwaSkladnika='Czosnek'
AND Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu);
GO

CREATE VIEW R18_przepisy_wolowina_cebula_marchew
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Wołowina') 
AND Przepisy.IDPrzepisu IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Cebula') 
AND Przepisy.IDPrzepisu IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Marchew');
GO

CREATE VIEW R18_przepisy_z_maslem_BEZ_wolowiny_cebuli_marchwi_GROUPBY
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika) LEFT JOIN (SELECT Skladniki_przepisow.IDPrzepisu FROM Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew'))  AS RIBOC
ON Przepisy.IDPrzepisu=RIBOC.IDPrzepisu
WHERE Skladniki.NazwaSkladnika='Masła'
AND RIBOC.IDPrzepisu Is Null
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
HAVING COUNT(RIBOC.IDPrzepisu)=0;
GO

CREATE VIEW R18_przepisy_bez_nabialu_DOBRZE
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu NOT IN
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM (Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) 
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika = 'Masła')
AND Przepisy.IDPrzepisu NOT IN
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM (Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) 
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika = 'Sery')
AND Przepisy.IDPrzepisu NOT IN
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM (Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) 
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika = 'Nabiał');
GO

CREATE VIEW R18_przepisy_bez_nabialu_ZLE
AS 
SELECT DISTINCT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika)
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika=Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika Not In ('Masła','Sery','Nabiał');
GO

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_GROUPBY
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy LEFT JOIN (SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow 
INNER JOIN Skladniki 
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew'))  AS RIBOC
ON Przepisy.IDPrzepisu=RIBOC.IDPrzepisu
WHERE RIBOC.IDPrzepisu IS NULL
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
HAVING COUNT(RIBOC.IDPrzepisu)=0;
GO

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_NOTEXISTS
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE NOT EXISTS  
(SELECT * FROM Skladniki_przepisow 
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika IN ('Wołowina', 'Cebula', 'Marchew') 
AND Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu);
GO

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_NOTIN_1
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Wołowina') 
AND Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Cebula') 
AND Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Marchew');
GO

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_NOTIN_2
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika IN ('Wołowina', 'Cebula', 'Marchew'));
GO

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_OUTERJOIN
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy LEFT JOIN (SELECT Skladniki_przepisow.IDPrzepisu FROM Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika=Skladniki.IDSkladnika WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew'))  AS RBeefCarrotOnion
ON Przepisy.IDPrzepisu=RBeefCarrotOnion.IDPrzepisu
WHERE RBeefCarrotOnion.IDPrzepisu Is Null;
GO

CREATE VIEW R21_katprzepisu_katskladnika_zliczanie_GROUPING_SETS
AS
SELECT CASE WHEN GROUPING(OpisKategoriiPrzepisu) = 0 
            THEN OpisKategoriiPrzepisu 
			ELSE 'Łącznie przepisów wszystkich kategorii' END AS KategoriaPrzepisu, 
  CASE WHEN GROUPING (OpisKategoriiSkladnika) = 0 
       THEN OpisKategoriiSkladnika 
	   ELSE 'Wszystkie kategorie składników' END AS KategoriaSkladnika,
  Count(Przepisy.IDPrzepisu) AS LacznaLiczbaPrzepisow
FROM Kategorie_przepisow 
  INNER JOIN Przepisy
    ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
  INNER JOIN Skladniki_przepisow
    ON Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu
  INNER JOIN Skladniki 
    ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
  INNER JOIN Kategorie_skladnikow
    ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika 
GROUP BY GROUPING SETS (OpisKategoriiPrzepisu, OpisKategoriiSkladnika);
GO

CREATE VIEW R21_katprzepisu_katskladnika_CUBE
AS
SELECT CASE WHEN GROUPING(OpisKategoriiPrzepisu) = 0 
            THEN OpisKategoriiPrzepisu 
			ELSE 'Łącznie przepisów wszystkich kategorii' END AS KategoriaPrzepisu, 
  CASE WHEN GROUPING (OpisKategoriiSkladnika) = 0 
       THEN OpisKategoriiSkladnika 
	   ELSE 'Wszystkie kategorie składników' END AS KategoriaSkladnika,
  Count(Przepisy.IDPrzepisu) AS LacznaLiczbaPrzepisow
FROM Kategorie_przepisow 
  INNER JOIN Przepisy
    ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
  INNER JOIN Skladniki_przepisow
    ON Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu
  INNER JOIN Skladniki 
    ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
  INNER JOIN Kategorie_skladnikow
    ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika 
GROUP BY CUBE (OpisKategoriiPrzepisu, OpisKategoriiSkladnika);
GO

CREATE VIEW R21_katprzepisu_liczba_przepisow_ROLLUP
AS
SELECT CASE WHEN GROUPING(OpisKategoriiPrzepisu) = 0 
            THEN OpisKategoriiPrzepisu 
			ELSE 'Łącznie przepisów wszystkich kategorii' END AS KategoriaPrzepisu,
  Count(Przepisy.IDPrzepisu) AS LacznaLiczbaPrzepisow
FROM Kategorie_przepisow 
  LEFT JOIN Przepisy
    ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
GROUP BY ROLLUP (OpisKategoriiPrzepisu);
GO

CREATE VIEW R22_skladniki_przepisy_zliczanie
AS
SELECT I.NazwaSkladnika, R.NazwaPrzepisu, 
  COUNT(*) OVER (
    PARTITION BY I.NazwaSkladnika
  ) AS LiczbaPrzepisow
FROM Przepisy AS R
  INNER JOIN Skladniki_przepisow AS RI
    ON RI.IDPrzepisu = R.IDPrzepisu
  INNER JOIN Skladniki AS I
    ON I.IDSkladnika = RI.IDSkladnika;
GO

CREATE VIEW R22_skladniki_wg_kategorii_skladnika
AS
SELECT ROW_NUMBER() OVER (
    ORDER BY IC.OpisKategoriiSkladnika, I.NazwaSkladnika
  ) AS NumerOgolny,
  IC.OpisKategoriiSkladnika, 
  ROW_NUMBER() OVER (
    PARTITION BY IC.OpisKategoriiSkladnika
    ORDER BY I.NazwaSkladnika
  ) AS NumerWKat,
  I.NazwaSkladnika
FROM Kategorie_skladnikow AS IC
  LEFT JOIN Skladniki AS I
    ON I.IDKategoriiSkladnika = IC.IDKategoriiSkladnika;
GO

CREATE VIEW R22_kategorie_przepisow_numerowanie
AS
SELECT ROW_NUMBER() OVER (
    ORDER BY RC.OpisKategoriiPrzepisu, R.NazwaPrzepisu
  ) AS NumerOgolny,
  RC.OpisKategoriiPrzepisu, 
  ROW_NUMBER() OVER (
    PARTITION BY RC.OpisKategoriiPrzepisu
    ORDER BY R.NazwaPrzepisu
  ) AS NumerWKat,
  R.NazwaPrzepisu
FROM Kategorie_przepisow AS RC
  LEFT JOIN Przepisy AS R
    ON R.IDKategoriiPrzepisu  = RC.IDKategoriiPrzepisu;
GO

CREATE VIEW R22_przepisy_skladniki_zliczanie
AS
SELECT R.NazwaPrzepisu, I.NazwaSkladnika,
  COUNT(*) OVER (
    PARTITION BY R.NazwaPrzepisu
  ) AS LiczbaSkladnikow
FROM Przepisy AS R
  INNER JOIN Skladniki_przepisow AS RI
    ON RI.IDPrzepisu = R.IDPrzepisu
  INNER JOIN Skladniki AS I
    ON I.IDSkladnika = RI.IDSkladnika;
GO
